/*
 * @(#)ImageLoopItem.java	1.21 95/03/22 James Gosling
 *
 * Copyright (c) 1994 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

import java.io.InputStream;
import awt.*;
import browser.*;
import net.www.html.*;

/**
 * ImageLook class. This is a container for a list
 * of images that can be animated.
 *
 * @author 	James Gosling
 * @version 	1.21, 22 Mar 1995
 */
class ImageLoop {
    /**
     * The images.
     */
    Image imgs[];

    /**
     * The number of images actually loaded.
     */
    int nimgs = 0;

    /**
     * Load the images, from dir. The images are assumed to be
     * named T1.gif, T2.gif...
     * Once all images are loaded the applet is resized to the
     * maximum width and height.
     */
    ImageLoop(URL context, String dir, ImageLoopItem parent) {
	int maxWidth  = 65;
	int maxHeight = 65;

	imgs = new Image[40];
	for (int i = 1; i < imgs.length; i++) {
	    Image im = parent.getImage(dir + "/T" + i + ".gif");

	    if (im == null) {
		break;
	    }

	    imgs[nimgs++] = im;
	    if (im.width > maxWidth) {
		maxWidth = im.width;
	    }
	    if (im.height > maxHeight) {
		maxHeight = im.height;
	    }
	}
	parent.resize(maxWidth, maxHeight);
    }
}


/**
 * A simple Item class to play an image loop.  The "img" tag parameter
 * indicates what image loop to play.
 *
 * @author 	James Gosling
 * @version 	1.21, 22 Mar 1995
 */
public class ImageLoopItem extends Applet implements Runnable {
    /**
     * The current loop slot.
     */
    int loopslot = 0;
    int cycleslot = 0;

    /**
     * The directory or URL from which the images are loaded
     */
    String dir;

    /**
     * The image loop.
     */
    ImageLoop loop;

    /**
     * The thread animating the images.
     */
    Thread kicker = null;

    /**
     * The length of the pause between revs.
     */
    int pause;

    /**
     * The speed at which the icon changes
     */
    int nSpeed;

    /**
     * The position of the icon
     */
    int nX, nY;
    int pnX[] = { 50, 48, 45, 39, 32, 24, 17, 10, 4, 1, 0, 1, 4, 10, 
         17, 25, 32, 39, 45, 48  };
    int pnY[] = { 25, 32, 39, 45, 48, 49, 48, 45, 39, 32, 24, 17, 10, 
         4, 1, 0, 1, 4, 10, 17  };
    boolean bDirection = true;

    /**
     * Initialize the applet. Get attributes.
     */
    public void init() {
	String at = getAttribute("img");
	dir = (at != null) ? at : "doc:/demo/images/duke";
	at = getAttribute("pause");
	pause = (at != null) ? Integer.valueOf (at).intValue() : 0;
	at = getAttribute("speed");
	nSpeed = (at!= null) ? Integer.valueOf (at).intValue() : 10000;

        nX = nY = 0;
    }

    /**
     * Run the image loop. This methods is called by class Thread.
     * @see java.lang.Thread
     */
    public void run() {
	Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
	loop = new ImageLoop(documentURL, dir, this);

	if (loop.nimgs > 1) {
	    while (width > 0 && height > 0 && kicker != null) {

                if (bDirection)
                    cycleslot++;
                else
                    cycleslot--;

                if (cycleslot == 20) {
                    cycleslot = 0;
                    }
                else if (cycleslot == -1) {
                    cycleslot = 19;
                    }

                nX =  pnX[cycleslot];
                nY =  pnY[cycleslot];

		repaint();
		Thread.sleep(nSpeed + ((loopslot == 0) ? pause : 0));
	    }
	}
    }

    /**
     * Paint the current frame.
     */
    public void paint(Graphics g) {
	if ((loop != null) && (loop.imgs != null) &&
	    (loopslot < loop.nimgs) && (loop.imgs[loopslot] != null)) {
	    g.drawImage(loop.imgs[loopslot], nX, nY);
	}
    }

    /**
     * Reverse the direction and change the color
     */
    public void mouseDown(int x, int y) 
    {
    if (++loopslot >= loop.nimgs) {
        loopslot = 0;
        }
    bDirection = !bDirection;
    }

    /**
     * Start the applet by forking an animation thread.
     */
    public void start() {
	if (kicker == null) {
	    kicker = new Thread(this);
	    kicker.start();
	}
    }

    /**
     * Stop the applet. The thread will exit because kicker is set to null.
     */
    public void stop() {
	kicker = null;
    }
}
